#include <stdint.h>

/* ----------------- Example code from MISRA C:2012 begin ----------------- */

void fn1 ( void )
{
  uint8_t  a[ 10 ];
  uint8_t *ptr;
  uint8_t  index = 0U;

  index = index + 1U;   /* Compliant     */

  a[ index ] = 0U;      /* Compliant     */
  ptr = &a[ 5 ];        /* Compliant     */

  ptr = a;
  ptr++;                /* Compliant     */
  *( ptr + 5 ) = 0U;    /* Non-compliant */
  ptr[ 5 ] = 0U;        /* Compliant     */
}

void fn2 ( void )
{
  uint8_t array_2_2[ 2 ][ 2 ] = { { 1U, 2U }, { 4U, 5U } };
  uint8_t i = 0U;
  uint8_t j = 0U;
  uint8_t sum = 0U;

  for ( i = 0U; i < 2U; i++ )
  {
    uint8_t *row = array_2_2[ i ];

    for ( j = 0U; j < 2U; j++ )
    {
      sum += row[ j ];  /* Compliant     */
    }
  }
}

void fn3 ( uint8_t *p1, uint8_t p2[ ] )
{
  p1++;                 /* Compliant     */
  p1 = p1 + 5;          /* Non-compliant */
  p1[ 5 ] = 0U;         /* Compliant     */

  p2++;                 /* Compliant     */
  p2 = p2 + 3;          /* Non-compliant */
  p2[ 3 ] = 0U;         /* Compliant     */
}

uint8_t a1[ 16 ];
uint8_t a2[ 16 ];
uint8_t data = 0U;

void fn4 ( void )
{
  fn3 ( a1, a2 );
  fn3 ( &data, &a2[ 4 ] );
}

/* ------------------ Example code from MISRA C:2012 end ------------------ */
